#!/bin/bash

# Step 1: How to construct bed file from file named input_file.res (from pipeline)
awk -F $'\t' 'BEGIN {OFS = FS} NR>1 {split($0,a,"|"); split(a[1],b,":"); split(a[2],c,"_"); split(a[3],d,"_"); if (substr(a[2],length(a[2]),1) != "+" && substr(a[2],length(a[2]),1) != "-") print b[1] "\t" b[2] "\t" b[3]"_"d[4]"_"d[5] "\t1\t" substr(a[3],length(a[3]),1); else print b[1] "\t" b[2] "\t" b[3]"_"c[4]"_"c[5] "\t1\t" substr(a[2],length(a[2]),1)}' input_file.res > listeIPA_peak.bed
echo -e "Change space"
sed -i 's/\-/\t/1' list_peak.bed

NB_ADD=150

# Step 2: How to change peaks coordinates from previously construct bed file (only for one of the two bed files)
# changing on only one side depending on the strand (end if +, start if -)
awk -v NB_ADD="${NB_ADD}" -F $'\t' 'BEGIN {OFS = FS} {if ($6 =="+") print $1 "\t" $2 "\t" $3+NB_ADD "\t" $4 "\t" $5 "\t" $6; else print $1 "\t" $2-NB_ADD "\t" $3 "\t" $4 "\t" $5 "\t" $6;}' list_peak.bed > list_peak_modifCoord.bed

BEDTOOLS_PATH=# Add path to bedtools

# Step 3: How to compare files using bedtool intersect - Please change name's files and list of names accordingly
cmd="${BEDTOOLS_PATH}/intersectBed -a list_peak_modifCoord.bed -b list_peak.bed -wa -wb -s > intersect_list_peak_modifCoord.bed"
evalecho "$cmd"

# Step 3 bis: How to compare files using bedtool intersect, just counting intersections - Please change name's files and list of names accordingly
cmd="${BEDTOOLS_PATH}/intersectBed -a list_peak_modifCoord.bed -b list_peak.bed -c -s > intersect_list_peak_modifCoord_cpt.bed"
evalecho "$cmd"
